package testoscm;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
//import javax.swing.JMenuBar;
//import javax.swing.JWindow;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import java.awt.BorderLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

class MyWindow extends JFrame implements Runnable {
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private  int  [] hScope = new int[10] ;
	private JFrame frame;
	private JSlider SliderM;
	private JSlider SliderA;
	private JPanel PanelA;
	private JCheckBox CheckBoxSlow = new javax.swing.JCheckBox();
	private JLabel LabelSlow = new javax.swing.JLabel("Slow");
	private float A=0;
	private float w=1;
    private boolean bSlow=true;
	@Override
	public void run() {
		// The following must be done from the same thread:
		hScope[0] = osc.ScopeCreate(0, "scope_1.ini", "a");
		osc.ScopeSetCaption(hScope[0],"sin-cos");
		osc.ScopeShow(hScope[0]);

		hScope[1] = osc.ScopeCreate(1, "scope_2.ini", "a");
		osc.ScopeSetCaption(hScope[1],"ramp");
		osc.ScopeShow(hScope[1]);

		osc.messageloop();//loop forever till quite
	};
	MyWindow()
	{
		//hScope=_hScope;
		frame = new JFrame("Oscilloscope Demo");
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.add(new JButton(), BorderLayout.CENTER);
		
		PanelA = new JPanel();
		
		
		//set look and feel
		JFrame.setDefaultLookAndFeelDecorated(true);
		//JLabel labelM = new JLabel("F");
		///labelM.setBounds(50, 50, 200, 30);
		//frame.add(labelM);
		
		SliderM = new JSlider(JSlider.HORIZONTAL);
		SliderM.setBounds(50, 50, 200, 30);
		SliderM.addChangeListener(new ChangeListener() {
	         public void stateChanged(ChangeEvent ce) {
	        	 w = SliderM.getValue();
	             //repaint();
	         }
	      });

		PanelA.add(SliderM);
		
		SliderA = new JSlider(JSlider.HORIZONTAL);
		SliderA.addChangeListener(new ChangeListener() {
	         public void stateChanged(ChangeEvent ce) {
	        	 A = SliderA.getValue();
	             //repaint();
	         }
	      });

		SliderA.setBounds(350, 350, 200, 30);
		PanelA.add(SliderA);
		
		CheckBoxSlow.setSelected(bSlow);
		CheckBoxSlow.addItemListener(new ItemListener() {

			public void itemStateChanged(ItemEvent e) {
				if ( CheckBoxSlow.isSelected())
				
				//if(e.getStateChange() == ItemEvent.SELECTED)
				{ 
		            bSlow = true;
		        }
				else
		        { 
					bSlow = false;
		        };
	         }
	      });

		CheckBoxSlow.setBounds(450, 350, 200, 30);
		PanelA.add(CheckBoxSlow);

		PanelA.add(LabelSlow);
		
		frame.add(PanelA);
		
		
		frame.pack();
		frame.setVisible(true);
		
		A = SliderA.getValue();
		w = SliderM.getValue();

		int poolSize = 3;
		ExecutorService taskList =
		Executors.newFixedThreadPool(poolSize);
		
		taskList.execute(this);
		
		double [] vals = new double [3];
		double [] vals2 = new double [3];
		
		vals[0]=10;vals[1]=20;vals[2]=30;
		int Ind =0;
		for ( ; ;)
		{
			Ind++;
			if ( (bSlow==true) && ( Ind % 4095 ) != 0  )
			{
				continue;
			}
			
			vals[0]=vals[0]+0.01f;
			if (vals[0] > 6.28f  )
				vals[0]=vals[0]-6.28f;
			//final float A = SliderA.getValue();
			//final float w = SliderM.getValue();
			vals[1]=java.lang.Math.sin(vals[0]*w)*A;
			vals[2]=java.lang.Math.cos(vals[0]*w)*A;
			osc.ShowNext(hScope[0], vals );
			
			vals2[0]=vals[0]*A;
			vals2[1]=  java.lang.Math.sin(vals[0]*w*w)*A; 
			vals2[2]=-vals[0]*A;
			osc.ShowNext(hScope[1], vals2 );
		}


	}
};


public class testoscm  {
	//public static int hScope;
	static boolean  bProceed=true;
	static MyWindow mywin;
	public static void main(String[] args) {
		// TODO Auto-generated method stub
		System.out.println("Starting...");
		final int stat = osc.AtOpenLib(1);
		System.out.println("stat="+stat);
		//hScope = osc.ScopeCreate(0, "scope_1.ini", "a");
		try {
			mywin = new MyWindow();
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		//return ;
					

	}

}
