//#include "pch.h"

#include <windows.h>
#include "osclib.h"
#define DllName  L"Osc_DLL64"



/////////////////

extern char * pEmpty = "";



char const EmptyM[4] = {0,0,0,0};

    // DLL functions begin
int (__cdecl  * AtOpenLib)(int Prm);
int (__cdecl  *     ScopeCreate)   (int Prm , wchar_t  *P_IniName, wchar_t *P_IniSuffix);
int (__cdecl  *     ScopeDestroy)  (int Prm);
int (__cdecl  *     ScopeShow)      (int Prm);
int (__cdecl  *     ScopeHide)       (int Prm);
int (__cdecl  *     ScopeShowNext)    (int Prm, struct  tagTArrDbl *PrmD );
int(__cdecl  * ScopeExtNext)(int ScopeHandle, double* PDbl);

int(__cdecl  * ScopeCleanBuffers)(int ScopeHandle);
int(__cdecl  * ScopeQuickUpDate)(int ScopeHandle);

int(__cdecl  * ScopeSetPanelState)(int ScopeHandle, int VisState);
int(__cdecl  * ScopeSetFormPos)(int ScopeHandle, int FormLeft, int FormTop);
int(__cdecl  * ScopeSetFormSize)(int ScopeHandle, int FormWidth, int FormHeight);
int(__cdecl  * ScopeSetCellPixelSize)(int ScopeHandle, int CellPixelSize);
int(__cdecl  * ScopeSetCellSampleSize)(int ScopeHandle, double CellSampleSize);
int(__cdecl  * ScopeSetCaption)(int ScopeHandle, wchar_t *Caption);
int(__cdecl  * ScopeSetAmpScale)(int ScopeHandle, int BeamNum, double  AmpScale);
int(__cdecl  * ScopeSetAmpOffset)(int ScopeHandle, int BeamNum, double  AmpOffset);
int(__cdecl  * ScopeSetActiveTriggerEdge)(int ScopeHandle, int TriggerEdge);
int(__cdecl  * ScopeSetTrigHoldOffSmplsNum)(int ScopeHandle, int  HoldOffVal);
int(__cdecl  * ScopeSetTriggerSourse)(int ScopeHandle, int BeamNum);


HINSTANCE DllInst;
int Scopes[7];



BOOL LoadOscDllFunctions()
{

	AtOpenLib = (int (__cdecl  * )(int))GetProcAddress(DllInst, "AtOpenLib");
   if (AtOpenLib == NULL)
   { perror( "Error -2" ) ; 
     return  FALSE;
   }
   AtOpenLib(0);



   ScopeShowNext  = (int (__cdecl  * )(int, struct tagTArrDbl *))GetProcAddress(DllInst, "ShowNext");
   if (ScopeShowNext == NULL) 
   {
	   perror( "Error -2" ) ;
     return  FALSE;
   }

   ScopeCreate  = (int (__cdecl  * )(int, wchar_t *, wchar_t *))GetProcAddress(DllInst, "ScopeCreate");
   if (ScopeCreate == NULL) 
   {
	   perror( "Error -2" ) ;
     return  FALSE;
   }

   
   ScopeDestroy  = (int (__cdecl  * )(int))GetProcAddress(DllInst, "ScopeDestroy");
   if (ScopeDestroy == NULL) 
   {
	   perror( "Error -2" ) ;
     return  FALSE;
   }

   ScopeShow  = (int (__cdecl  * )(int))GetProcAddress(DllInst, "ScopeShow");
   if (ScopeShow == NULL) 
   {
	   perror( "Error -2" ) ;
     return  FALSE;
   }

   ScopeHide  = (int (__cdecl  * )(int))GetProcAddress(DllInst, "ScopeHide");
   if (ScopeHide == NULL) 
   {
	   perror( "Error -2" ) ;
     return  FALSE;
   }


   ScopeQuickUpDate  = (int (__cdecl  * )(int))GetProcAddress(DllInst, "QuickUpDate");
   if (ScopeQuickUpDate == NULL) 
   {
	   perror( "Error -2" ) ;
     return  FALSE;
   }

   ScopeExtNext = (int(__cdecl  *)(int,double *))GetProcAddress(DllInst, "ExternalNext");
   if (ScopeExtNext == NULL)
   {
	   perror("Error -2");
	   return  FALSE;
   }

   ScopeCleanBuffers = (int(__cdecl  *)(int))GetProcAddress(DllInst, "ScopeCleanBuffers");
   if (ScopeCleanBuffers == NULL)
   {
	   perror("Error -2");
	   return  FALSE;
   }

   ScopeSetPanelState = (int(__cdecl  *)(int,int))GetProcAddress(DllInst, "ScopeSetPanelState");
   if (ScopeSetPanelState == NULL)
   {
	   perror("Error -2");
	   return  FALSE;
   }
   ScopeSetFormPos = (int(__cdecl  *)(int, int,int))GetProcAddress(DllInst, "ScopeSetFormPos");
   if (ScopeSetFormPos == NULL)
   {
	   perror("Error -2");
	   return  FALSE;
   }
   ScopeSetFormSize = (int(__cdecl  *)(int, int, int))GetProcAddress(DllInst, "ScopeSetFormSize");
   if (ScopeSetFormSize == NULL)
   {
	   perror("Error -2");
	   return  FALSE;
   }
   ScopeSetCellPixelSize = (int(__cdecl  *)(int, int ))GetProcAddress(DllInst, "ScopeSetCellPixelSize");
   if (ScopeSetCellPixelSize == NULL)
   {
	   perror("Error -2");
	   return  FALSE;
   }
   ScopeSetCaption = (int(__cdecl  *)(int, wchar_t *))GetProcAddress(DllInst, "ScopeSetCaption");
   if (ScopeSetCaption == NULL)
   {
	   perror("Error -2");
	   return  FALSE;
   }
   ScopeSetAmpScale = (int(__cdecl  *)(int, int,double))GetProcAddress(DllInst, "ScopeSetAmpScale");
   if (ScopeSetAmpScale == NULL)
   {
	   perror("Error -2");
	   return  FALSE;
   }
   ScopeSetAmpOffset = (int(__cdecl  *)(int, int, double))GetProcAddress(DllInst, "ScopeSetAmpOffset");
   if (ScopeSetAmpOffset == NULL)
   {
	   perror("Error -2");
	   return  FALSE;
   }
   ScopeSetActiveTriggerEdge = (int(__cdecl  *)(int, int ))GetProcAddress(DllInst, "ScopeSetActiveTriggerEdge");
   if (ScopeSetActiveTriggerEdge == NULL)
   {
	   perror("Error -2");
	   return  FALSE;
   }
   ScopeSetTrigHoldOffSmplsNum = (int(__cdecl  *)(int, int))GetProcAddress(DllInst, "ScopeSetTrigHoldOffSmplsNum");
   if (ScopeSetTrigHoldOffSmplsNum == NULL)
   {
	   perror("Error -2");
	   return  FALSE;
   }
   ScopeSetTriggerSourse = (int(__cdecl  *)(int, int))GetProcAddress(DllInst, "ScopeSetTriggerSourse");
   if (ScopeSetTriggerSourse == NULL)
   {
	   perror("Error -2");
	   return  FALSE;
   }

return TRUE;
}






BOOL InitInstance() 
{
	// TODO: Add your specialized code here and/or call the base class
	AtOpenLib = NULL;
		ScopeShowNext     = NULL;
		ScopeCreate       = NULL;
		ScopeQuickUpDate  = NULL;
		ScopeHide         = NULL;
		ScopeShow         = NULL;
		ScopeDestroy      = NULL;
	Scopes[1] = 0;

	
	DllInst =  LoadLibrary( DllName);
	if (DllInst==NULL)
	{
					perror( "Error -1" ) ;
					return FALSE;
	} 
	if (LoadOscDllFunctions()==FALSE)
	{
		DllInst=NULL;
		return FALSE;
	}
	return 0;
}

int ExitInstance() 
{
	// TODO: Add your specialized code here and/or call the base class
	if (DllInst)
	{
			if (Scopes[1])
			{
			ScopeDestroy(Scopes[1]);
			Sleep(500);
			}

		FreeLibrary(DllInst);
	}

	return 0;
}

BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{

    switch (ul_reason_for_call)
	{
	 case DLL_PROCESS_ATTACH:
         InitInstance();
			break;
		case DLL_THREAD_ATTACH:
			break;
		case DLL_THREAD_DETACH:
			break;
		case DLL_PROCESS_DETACH:
            ExitInstance();
			break;
    }
    return TRUE;
}

