// dllmain.cpp : Defines the entry point for the DLL application.
//#include "pch.h"
#include "framework.h"
#include "osclib.h"
/*
BOOL APIENTRY DllMain( HMODULE hModule,
                       DWORD  ul_reason_for_call,
                       LPVOID lpReserved
                     )
{
    switch (ul_reason_for_call)
    {
    case DLL_PROCESS_ATTACH:
		InitInstance();

    case DLL_THREAD_ATTACH:
    case DLL_THREAD_DETACH:
    case DLL_PROCESS_DETACH:
        break;
    }
    return TRUE;
}
*/

/**

static public native int AtOpenLib(int Prm);
static public native int  ScopeCreate(int Prm, String  P_IniName, String P_IniSuffix);
static public native int  ScopeDestroy(int ScopeHandle);
static public native int  ScopeShow(int ScopeHandle);
static public native  int   ScopeHide(int ScopeHandle);
static public native  int   ShowNext(int ScopeHandle, double[] PArrDbl);
*/
/// File: mainTunerDemoJni.c
/// Implements native methods of class com.tmc.tunerdemo.MainActivity
// located at:
//  src/com/tmc/tunerdemo/MainActivity.java
//
//contained in libTmcTunerDemo.so library:
//    public native String  runTmcTuning(float M);
//    public native int pidgetNumFreqs();
//    public native int pidgetTypeCrl();
//    public native int pidgetNumPlants();
//    public native int pidgetGetPlants(double [] a);
//    public native int pidgetNumCrl();
//    public native int pidgetGetCrl(double [] a);


#include <string.h>
#include "testoscm_osc.h" // generated by: javac -verbose -h ..\..\jni\Osc_DLL64_JNI  osc.java


//extern "C" __declspec(dllexport)
JNIEXPORT jint     JNICALL Java_testoscm_osc_AtOpenLib(
	JNIEnv *env,
	jobject callingObject, jint Prm)
{
	AtOpenLib(Prm);
	return Prm;
}

/*
 * Class:     testoscm_osc
 * Method:    ScopeCreate
 * Signature: (ILjava/lang/String;Ljava/lang/String;)I
 */
JNIEXPORT jint JNICALL Java_testoscm_osc_ScopeCreate
(JNIEnv *env, jclass callingObject, jint Prm, jstring inifile, jstring inisuf)
{
	wchar_t ansiString_inifile[300];
	wchar_t ansiString_inisuf[300];

	const jchar *raw = (*env)->GetStringChars(env, inifile, 0);
	jsize len = (*env)->GetStringLength(env, inifile);
	const jchar *temp = raw;
	int ind = 0;
	while (len > 0)
	{
		ansiString_inifile[ind++]  = *(temp++);
		len--;
	}
	ansiString_inifile[ind++] = 0;
	(*env)->ReleaseStringChars(env, inifile, raw);

	const jchar *raw2 = (*env)->GetStringChars(env, inisuf, 0);
	jsize len2 = (*env)->GetStringLength(env, inisuf);
	const jchar *temp2 = raw2;
	int ind2 = 0;
	while (len2 > 0)
	{
		ansiString_inisuf[ind2++] = *(temp2++);
		len2--;
	}
	ansiString_inisuf[ind2++] = 0;
	(*env)->ReleaseStringChars(env, inisuf, raw2);


//wchar_t * ansiString_inifile = (*env)->GetStringUTFChars(env,inifile, 0);
//wchar_t * ansiString_inisuf  = (*env)->GetStringUTFChars(env,inisuf,   0);
/*
jsize len1 = (*env)->GetStringLength(env, inifile);
jsize len2 = (*env)->GetStringLength(env, inisuf);

const jchar *temp = ansiString_inifile;
while (len1 > 0)
{
	value += *(temp++);
	len--;
}
(*env)->ReleaseStringChars(env,string, raw);
*/
	return ScopeCreate(Prm, ansiString_inifile, ansiString_inisuf);
}

/*
 * Class:     testoscm_osc
 * Method:    ScopeDestroy
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_testoscm_osc_ScopeDestroy
(JNIEnv *env, jclass callingObject, jint hScope)
{
	return ScopeDestroy(hScope);
}

/*
 * Class:     testoscm_osc
 * Method:    ScopeShow
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_testoscm_osc_ScopeShow
(JNIEnv *env, jclass callingObject, jint hScope)
{
	return ScopeShow(hScope);
}

/*
 * Class:     testoscm_osc
 * Method:    ScopeHide
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_testoscm_osc_ScopeHide
(JNIEnv *env, jclass callingObject, jint hScope)
{
	return ScopeHide(hScope);
}

/*
 * Class:     testoscm_osc
 * Method:    ShowNext
 * Signature: (I[D)I
 */
JNIEXPORT jint JNICALL Java_testoscm_osc_ShowNext
(JNIEnv *env, jclass callingObject, jint hScope, jdoubleArray vals)
{
	int stat;
	struct tagTArrDbl mvals;
	double* xPtr = (*env)->GetDoubleArrayElements(env,vals, 0);
	mvals.s1 = xPtr[0];
	mvals.s2 = xPtr[1];
	mvals.s3 = xPtr[2];

	stat = ScopeShowNext(hScope,& mvals);

	(*env)->ReleaseDoubleArrayElements(env, vals, xPtr, JNI_ABORT);
	return stat;

}


/*
 * Class:     testoscm_osc
 * Method:    ScopeCleanBuffers
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_testoscm_osc_ScopeCleanBuffers
(JNIEnv *env, jclass callingObject, jint hScope)
{
	return ScopeCleanBuffers(hScope);
}

/*
 * Class:     testoscm_osc
 * Method:    ScopeQuickUpDate
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_testoscm_osc_ScopeQuickUpDate
(JNIEnv *env, jclass callingObject, jint hScope)
{
	return ScopeQuickUpDate(hScope);
}

/*
 * Class:     testoscm_osc
 * Method:    ScopeExtNext
 * Signature: (I[D)I
 */
JNIEXPORT jint JNICALL Java_testoscm_osc_ScopeExtNext
(JNIEnv *env, jclass callingObject, jint hScope, jdoubleArray TrigVal)
{
	int stat;
	double trigval;
	double* xPtr = (*env)->GetDoubleArrayElements(env, TrigVal, 0);
	trigval = xPtr[0];

	stat = ScopeExtNext(hScope, &trigval);

	(*env)->ReleaseDoubleArrayElements(env, TrigVal, xPtr, JNI_ABORT);
	return stat;
}

/*
 * Class:     testoscm_osc
 * Method:    ScopeSetPanelState
 * Signature: (II)I
 */
JNIEXPORT jint JNICALL Java_testoscm_osc_ScopeSetPanelState
(JNIEnv *env, jclass callingObject, jint hScope, jint VisState)
{
	return ScopeSetPanelState(hScope, VisState);
}

/*
 * Class:     testoscm_osc
 * Method:    ScopeSetFormPos
 * Signature: (III)I
 */
JNIEXPORT jint JNICALL Java_testoscm_osc_ScopeSetFormPos
(JNIEnv *env, jclass callingObject, jint hScope, jint FormLeft, jint FormTop)
{
	return ScopeSetFormPos(hScope, FormLeft,   FormTop);
}

/*
 * Class:     testoscm_osc
 * Method:    ScopeSetFormSize
 * Signature: (III)I
 */
JNIEXPORT jint JNICALL Java_testoscm_osc_ScopeSetFormSize
(JNIEnv *env, jclass callingObject, jint hScope, jint FormWidth, jint FormHeight)
{
	return ScopeSetFormSize(hScope, FormWidth, FormHeight);
}

/*
 * Class:     testoscm_osc
 * Method:    ScopeSetCellPixelSize
 * Signature: (II)I
 */
JNIEXPORT jint JNICALL Java_testoscm_osc_ScopeSetCellPixelSize
(JNIEnv *env, jclass callingObject, jint hScope, jint CellPixelSize)
{
	return ScopeSetCellPixelSize(hScope, CellPixelSize);
}

/*
 * Class:     testoscm_osc
 * Method:    ScopeSetCellSampleSize
 * Signature: (ID)I
 */
JNIEXPORT jint JNICALL Java_testoscm_osc_ScopeSetCellSampleSize
(JNIEnv *env, jclass callingObject, jint hScope, jdouble CellSampleSize)
{
	return ScopeSetCellSampleSize(hScope, CellSampleSize);
}

/*
 * Class:     testoscm_osc
 * Method:    ScopeSetCaption
 * Signature: (ILjava/lang/String;)I
 */
JNIEXPORT jint JNICALL Java_testoscm_osc_ScopeSetCaption
(JNIEnv *env, jclass callingObject, jint hScope, jstring Caption) {
	

	wchar_t ansiString_Caption[300];

	const jchar *raw = (*env)->GetStringChars(env, Caption, 0);
	jsize len = (*env)->GetStringLength(env, Caption);
	const jchar *temp = raw;
	int ind = 0;
	while (len > 0)
	{
		ansiString_Caption[ind++] = *(temp++);
		len--;
	}
	ansiString_Caption[ind++] = 0;
	(*env)->ReleaseStringChars(env, Caption, raw);

	return ScopeSetCaption(hScope, ansiString_Caption);
}

/*
 * Class:     testoscm_osc
 * Method:    ScopeSetAmpScale
 * Signature: (IID)I
 */
JNIEXPORT jint JNICALL Java_testoscm_osc_ScopeSetAmpScale
(JNIEnv *env, jclass callingObject, jint hScope, jint BeamNum, jdouble AmpScale)
{
	return ScopeSetAmpScale(hScope, BeamNum,   AmpScale);
}

/*
 * Class:     testoscm_osc
 * Method:    ScopeSetAmpOffset
 * Signature: (IID)I
 */
JNIEXPORT jint JNICALL Java_testoscm_osc_ScopeSetAmpOffset
(JNIEnv *env, jclass callingObject, jint hScope, jint BeamNum, jdouble AmpOffset)
{
	return ScopeSetAmpOffset(hScope, BeamNum,   AmpOffset);
}

/*
 * Class:     testoscm_osc
 * Method:    ScopeSetActiveTriggerEdge
 * Signature: (II)I
 */
JNIEXPORT jint JNICALL Java_testoscm_osc_ScopeSetActiveTriggerEdge
(JNIEnv *env, jclass callingObject, jint hScope, jint TriggerEdge)
{
	return ScopeSetActiveTriggerEdge(hScope, TriggerEdge);
}

/*
 * Class:     testoscm_osc
 * Method:    ScopeSetTrigHoldOffSmplsNum
 * Signature: (II)I
 */
JNIEXPORT jint JNICALL Java_testoscm_osc_ScopeSetTrigHoldOffSmplsNum
(JNIEnv *env, jclass callingObject, jint hScope, jint HoldOffVal)
{
	return ScopeSetTrigHoldOffSmplsNum(hScope, HoldOffVal);
}

/*
 * Class:     testoscm_osc
 * Method:    ScopeSetTriggerSourse
 * Signature: (II)I
 */
JNIEXPORT jint JNICALL Java_testoscm_osc_ScopeSetTriggerSourse
(JNIEnv *env, jclass callingObject, jint hScope, jint BeamNum)
{
	return ScopeSetTriggerSourse(hScope, BeamNum);
}


///////////////////////////////////////////////////////////////
/*
 * Class:     testoscm_osc
 * Method:    messageloop
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_testoscm_osc_messageloop
(JNIEnv *env, jclass callingObject)
{
	MSG msg;
	while (GetMessage(&msg, NULL, 0, 0)) {
		TranslateMessage(&msg); /* for certain keyboard messages */
		DispatchMessage(&msg); /* send message to WndProc */
	}

	return 0;

}

